// CLS_DlgPicSnap.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "MainViewDlg.h"
#include "CLS_DlgPicSnap.h"
#include "RetValue.h"

// CLS_DlgPicSnap dialog

IMPLEMENT_DYNAMIC(CLS_DlgPicSnap, CDialog)

CLS_DlgPicSnap::CLS_DlgPicSnap(CMainViewDlg* _pMainView,int _iSnapID,CWnd* pParent /*=NULL*/)
	: CDialog(CLS_DlgPicSnap::IDD, pParent),
	m_pMainView(_pMainView)
	, m_iSnapID(_iSnapID)
	, m_csFilename(_T(""))
{

}

CLS_DlgPicSnap::~CLS_DlgPicSnap()
{
}

void CLS_DlgPicSnap::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_SNAPID, m_iSnapID);
	DDX_Text(pDX, IDC_EDIT_FILENAME, m_csFilename);
}


BEGIN_MESSAGE_MAP(CLS_DlgPicSnap, CDialog)
	ON_BN_CLICKED(IDC_BTN_GETFILENAME, &CLS_DlgPicSnap::OnBnClickedBtnGetfilename)
	ON_BN_CLICKED(IDC_BTN_DEL_PICSNAP, &CLS_DlgPicSnap::OnBnClickedBtnDelPicsnap)
END_MESSAGE_MAP()


// CLS_DlgPicSnap message handlers

void CLS_DlgPicSnap::OnBnClickedBtnGetfilename()
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_csFilename = "";
	if(NULL!=m_pMainView)
	{
		m_pMainView->CmdPicSnap(DEC_COMMAND_GETPICFILENAME,m_iSnapID);
	}
	UpdateData(FALSE);
}

void CLS_DlgPicSnap::OnBnClickedBtnDelPicsnap()
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_csFilename = "";
	if(NULL!=m_pMainView)
	{
		m_pMainView->CmdPicSnap(DEC_COMMAND_DEL_PICSNAP,m_iSnapID);
	}
	UpdateData(FALSE);
}
void CLS_DlgPicSnap::SetPicFilename(CString _csFileName)
{
	m_csFilename = _csFileName;
	UpdateData(FALSE);
}
void CLS_DlgPicSnap::OnMainNotify(_MAIN_NOTIFY_DATA* _pData)
{
	int iType = _pData->m_iMsg;
	int iID = _pData->m_lID;
	switch(iType)
	{
	case DEC_WCM_DEC_PICSNAP:
		{
			if(RET_SUCCESS == _pData->tParam.tPicSnapResult.iRet)
			{
				m_iSnapID = _pData->tParam.tPicSnapResult.iSnapID;
			}else{
				MessageBox(GetTextByLan("ץʧܣ","Pic snap faild"), _T(""), MB_OK);
			}

		}
		break;
	case DEC_WCM_DEC_GETPICFILENAME:
		{
			if(RET_SUCCESS == _pData->tParam.tPicSnapFileName.iState)
			{
				m_csFilename = _pData->tParam.tPicSnapFileName.cPicFileName;
			}else{
				MessageBox(GetTextByLan("ȡļʧܣ","Get Pic Filename faild"), _T(""), MB_OK);
			}
			break;
		}
	default:
		break;
	}
	UpdateData(FALSE);
}
